from django.http import JsonResponse
from django.views.decorators.http import require_POST
from django.views.decorators.csrf import csrf_exempt

from staff.gap.api.forms import ImportMandatoryVacationsForm
from staff.gap.tasks import ImportMandatoryVacations


@require_POST
@csrf_exempt
def import_mandatory_vacations(request):
    form = ImportMandatoryVacationsForm(request.POST, request.FILES)

    if not form.is_valid():
        return JsonResponse(data=form.errors_as_dict(), status=400)

    vacations_data = form.cleaned_data['mandatory_vacations_data']

    ImportMandatoryVacations.delay(vacations_data)

    return JsonResponse({}, status=200)
