import json
from staff.lib import waffle

from django.views.decorators.csrf import csrf_exempt
from django.views.decorators.http import require_POST

from staff.lib.decorators import responding_json, available_for_external
from staff.lib.forms.errors import invalid_json_error

from staff.gap.tasks import SyncDutyGapsTask
from staff.gap.forms import NeedUpdateGapForm

import logging
logger = logging.getLogger('staff.gap.api.views.update_gap')


@available_for_external('gap.robot_with_gap_api_access')
@responding_json
@csrf_exempt
@require_POST
def need_update_gap(request, service_id):
    try:
        req_data = json.loads(request.body)
    except ValueError:
        logger.exception('Wrong JSON: %s', request.body)
        return invalid_json_error(request.body), 400

    req_data['service'] = int(service_id)

    form = NeedUpdateGapForm(req_data)
    if not form.is_valid():
        errs = form.errors_as_dict()
        return errs, 400

    if waffle.switch_is_active('enable_abc_duty_sync'):
        SyncDutyGapsTask.delay(service_id=form.cleaned_data['service'].service_id)

    return {}
