from staff.gap.api.exceptions import NoGapWithThisIssueKeyError
from staff.gap.controllers.gap import GapCtl


def get_gap_id_by_issue_key(issue_key: str) -> int:
    try:
        gap = next(GapCtl().find_gaps({'master_issue': issue_key}))
    except StopIteration:
        raise NoGapWithThisIssueKeyError()

    return gap['id']
