from django.contrib.auth.decorators import login_required
from django.views.decorators.http import require_GET

from staff.lib.decorators import responding_json, available_for_external

from staff.gap.workflows import ALL_WORKFLOWS_ORDER
from staff.gap.workflows.utils import find_workflow

import logging
logger = logging.getLogger('staff.gap.api.views.workflow_views')


@login_required
@responding_json
@require_GET
@available_for_external('gap.robot_with_gap_api_access')
def workflows(_request):
    return {'workflows': get_workflows_ref()}


def get_workflows_ref():
    result = []
    for name in ALL_WORKFLOWS_ORDER:
        w_cls = find_workflow(name)
        result.append({
            'type': w_cls.workflow,
            'color': w_cls.color,
            'verbose_name': {
                'ru': w_cls.verbose_name,
                'en': w_cls.verbose_name_en,
            }
        })
    return result
