from django.forms import (
    Form,
    CharField,
    DateField,
    IntegerField,
    ValidationError,
)


class CommaSeparatedStrings(CharField):

    def clean(self, data):
        data = super(CommaSeparatedStrings, self).clean(data)
        if not data and not self.required:
            return []

        list_ = [elem.strip() for elem in data.split(',')]
        if '' in list_ and list_.count('') == len(list_):
            raise ValidationError('Bad comma separated list: no elements')
        return list_


class DistributeVacationsForm(Form):
    date_from = DateField(required=True)
    days_to_spent = IntegerField(min_value=1, max_value=100, required=True)
