from staff.lib.mongodb import mongo


class CounterCtl(object):
    MONGO_COLLECTION = 'counters'

    @property
    def _collection(self):
        return mongo.db[self.MONGO_COLLECTION]

    def get_counter(self, name, increment=True):
        if not increment:
            result = self._collection.find_one({'_id': name})
            return result['seq']

        result = self._collection.find_and_modify(
            query={'_id': name},
            update={'$inc': {'seq': 1}},
            new=True,
            upsert=True,
        )
        return result['seq']

    def set_counter(self, name, value, collection):
        if collection not in mongo.db.collection_names():
            self._collection.insert_one({'_id': name, 'seq': value})
            return

        self._collection.replace_one({'_id': name}, {'seq': value})
