from staff.gap.controllers.mongo import MongoCtl


class GapSettingsCtl(MongoCtl):

    MONGO_COLLECTION = 'gap_settings'

    def __init__(self, cached=False):
        self.cached = cached
        if self.cached:
            self.cache = {}

    def update_workflow_files(self, data):
        self._upsert({'type': 'workflow_files'}, {'$set': {'settings': data}})

    def get_workflow_files(self):
        if self.cached:
            return self.get_workflow_files_cached()
        result = self.find_one(query={'type': 'workflow_files'})
        if result:
            return result['settings']
        return []

    def get_workflow_files_cached(self):
        if 'workflow_files' not in self.cache:
            workflow_files = self.find_one(query={'type': 'workflow_files'})
            if workflow_files:
                self.cache['workflow_files'] = workflow_files['settings']
            else:
                self.cache['workflow_files'] = []
        return self.cache['workflow_files']

    def find_workflow_file(self, organization_id, workflow, tag):
        workflow_files = self.get_workflow_files()
        for wf in workflow_files:
            if organization_id in wf['organization_ids'] and workflow in wf['workflows'] and tag == wf['tag']:
                return wf['file_url']
