import pymongo
from pymongo.read_preferences import ReadPreference

from staff.lib.mongodb import mongo


class MongoCtl(object):

    def recreate_collection(self):
        if self.MONGO_COLLECTION in mongo.db.collection_names():
            mongo.db.drop_collection(self.MONGO_COLLECTION)
        mongo.db.create_collection(self.MONGO_COLLECTION)

    def _collection(self, read_preference=ReadPreference.PRIMARY_PREFERRED):
        return mongo.db.get_collection(self.MONGO_COLLECTION, read_preference=read_preference)

    def _update(self, data):
        self._collection().update_one({'id': data['id']}, {'$set': data})

    def _insert(self, data):
        self._collection().insert_one(data)

    def _upsert(self, query, data):
        self._collection().update_one(filter=query, update=data, upsert=True)

    def find(self, query=None, fields=None, sorting=None, del_id=True):
        query = query or {}
        sorting = sorting or [('id', pymongo.ASCENDING)]

        if del_id:
            fields = dict.fromkeys(fields or [], True)
            if '_id' not in fields:
                fields['_id'] = False

        col = self._collection(read_preference=ReadPreference.SECONDARY_PREFERRED)
        result = col.find(query, projection=fields) if fields else col.find(query)

        return result.sort(sorting)

    def find_one(self, query, del_id=True):
        return self._collection().find_one(query)

    def remove(self, _id):
        self._collection().delete_one({'_id': _id})
