class QueryBuilder(object):

    def __init__(self):
        self._stack = []

    def query(self, use_and=True):
        return {
            '$and' if use_and else '$or': self._stack
        }

    def append(self, data):
        self._stack.append(data)
        return self

    def op_eq(self, name, data):
        return self.append({name: data})

    def op_in(self, name, data):
        return self.append({name: {'$in': data}})

    def op_gt(self, name, data):
        return self.append({name: {'$gt': data}})

    def op_gte(self, name, data):
        return self.append({name: {'$gte': data}})

    def op_lt(self, name, data):
        return self.append({name: {'$lt': data}})

    def op_lte(self, name, data):
        return self.append({name: {'$lte': data}})

    def op_or(self, data):
        return self.append({'$or': data})

    def op_and(self, data):
        return self.append({'$and': data})

    def op_not(self, name, data):
        return self.append({name: {'$not': data}})

    def op_ne(self, name, data):
        return self.append({name: {'$ne': data}})
