import pymongo
from staff.lib import waffle

from staff.person.models import Staff

from staff.person_profile.controllers.subordinates import (
    direct_subordinates_q,
    all_subordinates_q,
)

from staff.gap.controllers.gap import (
    GapCtl,
    GapQueryBuilder,
)
from staff.gap.workflows.absence.workflow import AbsenceWorkflow


def _unconfirmed_gaps_query(persons_ids):
    if waffle.switch_is_active('disable_long_absence'):
        query = (
            GapQueryBuilder()
            .person_ids(persons_ids)
            .state('new')
            .op_or([{'workflow': 'vacation'}])
            .query()
        )

        return query

    query = (
        GapQueryBuilder()
        .person_ids(persons_ids)
        .state('new')
        .op_or([
            {'workflow': 'vacation'},
            AbsenceWorkflow.long_absences_query_builder().query(),
        ])
        .query()
    )

    return query


def get_unconfirmed_gaps_count(persons_ids):
    return GapCtl().find_gaps(query=_unconfirmed_gaps_query(persons_ids)).count()


def get_unconfirmed_gaps(persons_ids, limit, page):
    fields = [
        'id',
        'workflow',
        'date_from',
        'date_to',
        'comment',
        'state',
        'person_id',
        'person_login',
        'full_day',
        'duration',
    ]

    sorting = [('date_from', pymongo.DESCENDING)]

    return (
        GapCtl().find_gaps(
            query=_unconfirmed_gaps_query(persons_ids),
            fields=fields,
            sorting=sorting,
        ).skip(page * limit).limit(limit)
    )


def get_unconfirmed_gaps_counters(person_id, direct_subordinates_ids=None,
                                  all_subordinates_ids=None):
    if all_subordinates_ids is None:
        all_subordinates_ids = _subordinates_ids(all_subordinates_q(person_id))

    if not all_subordinates_ids:
        return None

    if direct_subordinates_ids is None:
        direct_subordinates_ids = _subordinates_ids(direct_subordinates_q(person_id))

    return {
        'direct': get_unconfirmed_gaps_count(direct_subordinates_ids),
        'all': get_unconfirmed_gaps_count(all_subordinates_ids),
    }


def _subordinates_ids(q):
    # list потому, что pymongo: InvalidDocument: Cannot encode object: [..]
    return list(Staff.objects.filter(q).values_list('id', flat=True))


# ужасно
def unconfirmed_for_ui(observer_id, target_id=None, observer_login=None,
                       target_login=None):
    if target_id and observer_id != target_id:
        return {
            "enabled": False,
        }
    elif observer_login and target_login and observer_login != target_login:
        return {
            "enabled": False,
        }

    unconfirmed_counters = get_unconfirmed_gaps_counters(observer_id)
    if unconfirmed_counters is None:
        return {
            "enabled": False,
        }
    else:
        return {
            "enabled": True,
            "counters": unconfirmed_counters,
        }
