from django.contrib.auth.models import User

from staff.gap.exceptions import MandatoryVacationCancelError


def check_user_can_perform_gap_action(gap: dict, user: User, action_name: str):
    if action_name == 'cancel_gap':
        if (
            gap['workflow'] == 'vacation'
            and gap.get('mandatory', False)
            and not user.has_perm('gap.can_delete_mandatory_vacation')
        ):
            raise MandatoryVacationCancelError()
