import datetime

from staff.lib.exceptions import ErrorWithStatusCode


class GapError(Exception):
    pass


class GapViewError(GapError, ErrorWithStatusCode):
    pass


class GapNotFoundError(GapError):

    def __init__(self, msg):
        self.msg = msg
        super(GapNotFoundError, self).__init__()

    def __str__(self):
        return str(self.msg)


class WrongWorkflowStateError(GapError):

    def __init__(self, msg):
        super(WrongWorkflowStateError, self).__init__(msg)


class WrongWorkflowActionError(GapError):

    def __init__(self, msg):
        super(WrongWorkflowActionError, self).__init__(msg)


class DuplicateIssueError(GapError):

    def __init__(self, msg):
        super(DuplicateIssueError, self).__init__(msg)


class NoTemplateError(GapError):

    def __init__(self, msg):
        super(NoTemplateError, self).__init__(msg)


class MandatoryVacationError(GapError):

    def __init__(self, msg, key, **err_params):
        super().__init__(msg)
        self.error_msg = msg
        self.error_key = key
        self.err_params = err_params

    @property
    def error_dict(self):
        return {
            'error': {
                'msg': self.error_msg,
                'key': self.error_key,
                'params': self.err_params
            }
        }


class MandatoryVacationTooShortError(MandatoryVacationError):

    def __init__(self, min_date_to: datetime.date):
        super().__init__(
            msg='Mandatory vacation is too short',
            key='mandatory-vacation-too-short',
            min_date_to=min_date_to.isoformat(),
        )


class MandatoryVacationWithHolidaysTooShortError(MandatoryVacationError):

    def __init__(self, min_date_to: datetime.date):
        super().__init__(
            msg='Mandatory vacation includes holidays and should be longer',
            key='mandatory-vacation-with-holidays-too-short',
            min_date_to=min_date_to.isoformat(),
        )


class MandatoryVacationYearChangedError(MandatoryVacationError):

    def __init__(self):
        super().__init__(
            msg='You can not change year of mandatory vacation',
            key='mandatory-vacation-year-changed',
        )


class MandatoryVacationCancelError(MandatoryVacationError):

    def __init__(self):
        super().__init__(
            msg='You can not cancel vacation',
            key='mandatory-vacation-no-cancel',
        )
