from django.conf.urls import url

from staff.gap.gap_admin import views

urlpatterns = [
    url(
        r'^$',
        views.index_view.index,
        name='index',
    ),
    url(
        r'^edit_email_template/?$',
        views.edit_email_template_view.edit_email_template,
        name='edit-email-template',
    ),
    url(
        r'^edit_email_template/(?P<template_id>\w+)/?$',
        views.edit_email_template_view.edit_email_template,
        name='edit-email-template',
    ),
    url(
        r'^edit_pdf_template/?$',
        views.edit_pdf_template_view.edit_pdf_template,
        name='edit-pdf-template',
    ),
    url(
        r'^edit_pdf_template/(?P<template_id>\w+)/?$',
        views.edit_pdf_template_view.edit_pdf_template,
        name='edit-pdf-template',
    ),
    url(
        r'^edit_st_issue_template/?$',
        views.edit_st_issue_template_view.edit_st_issue_template,
        name='edit-st-issue-template',
    ),
    url(
        r'^edit_st_issue_template/(?P<template_id>\w+)/?$',
        views.edit_st_issue_template_view.edit_st_issue_template,
        name='edit-st-issue-template',
    ),
    url(
        r'^edit_st_issue_comment_template/?$',
        views.edit_st_issue_comment_template_view.edit_st_issue_comment_template,
        name='edit-st-issue-comment-template',
    ),
    url(
        r'^edit_st_issue_comment_template/(?P<template_id>\w+)/?$',
        views.edit_st_issue_comment_template_view.edit_st_issue_comment_template,
        name='edit-st-issue-comment-template',
    ),
    url(
        r'^list_templates/?$',
        views.list_templates_view.list_templates,
        name='list-templates',
    ),
    url(
        r'^remove_template/(?P<template_id>\w+)/?$',
        views.remove_template_view.remove_template,
        name='remove-template',
    ),
    url(
        r'^export_templates/?$',
        views.export_templates_view.export_templates,
        name='export-templates',
    ),
    url(
        r'^import_templates/?$',
        views.import_templates_view.import_templates,
        name='import-templates',
    ),
    url(
        r'^workflow_files_settings/?$',
        views.workflow_files_settings_view.workflow_files_settings,
        name='workflow-files-settings',
    ),
    url(
        r'^vacations_to_cancel/?$',
        views.vacations_to_cancel_view.vacations_to_cancel,
        name='vacations-to-cancel',
    ),
    url(
        r'^stats/?$',
        views.stats_view.stats,
        name='stats',
    ),
    url(
        r'^edit_gap/(?P<gap_id>\d+)/?$',
        views.edit_gap_view.edit_gap,
        name='edit-gap',
    ),
]
