from bson.objectid import ObjectId

from django.contrib.auth.decorators import permission_required, login_required
from django.core.urlresolvers import reverse
from django.shortcuts import render
from django.views.decorators.http import require_http_methods
from django.http import (
    HttpResponseNotFound,
    HttpResponseServerError,
    HttpResponseRedirect,
)

from staff.gap.controllers.templates import TemplatesCtl
from staff.gap.gap_admin.utils import (
    base_edit_template,
    base_new_template,
    edit_template_get,
    new_template_get,
)
from staff.gap.gap_admin.forms import EmailTemplateForm

import logging
logger = logging.getLogger('staff.gap.gap_admin.views.edit_email_template_view')


@require_http_methods(['POST', 'GET'])
@login_required
@permission_required('gap.gap_admin')
def edit_email_template(request, template_id=None):
    template_url = 'gap_admin/gap_templates/edit_email.html'

    if template_id is not None:
        context = _edit_template_get(template_id)
    else:
        context = _new_template_get()

    if request.method == 'GET':
        return render(request, template_url, {'template': context})

    form = EmailTemplateForm(request.POST)
    if form.is_valid():
        try:
            data = form.cleaned_data
            t_ctl = TemplatesCtl()
            if template_id is not None:
                template = t_ctl.find_one({'_id': ObjectId(template_id)})
                if not template:
                    return HttpResponseNotFound()
                template.update(base_edit_template(data))
                template.update(_template_data(data))
                t_ctl.update(template)
            else:
                template = base_new_template(data)
                template.update(_template_data(data))
                t_ctl.new(**template)
        except Exception:
            logger.exception('Error saving template')
            return HttpResponseServerError()

        return HttpResponseRedirect(reverse('gap-admin:list-templates'))

    return render(request, template_url, {'form': form, 'template': context})


def _edit_template_get(template_id):
    template = edit_template_get(template_id)
    if template:
        template['text'] = template['template']

    return template


def _new_template_get():
    return new_template_get('email', {
        'text': '.. заголовок письма .. два перевода строки .. тело письма ..',
    })


def _template_data(data):
    return {
        'template': data['email_text'],
    }
