from django.contrib.auth.decorators import login_required, permission_required
from django.http import HttpResponseServerError
from django.shortcuts import render
from django.views.decorators.http import require_http_methods

from staff.person.models import Staff

from staff.gap.controllers.gap import GapCtl
from staff.gap.gap_admin.utils import join_collection

import logging


logger = logging.getLogger('staff.gap.gap_admin.views.edit_gap_view')


@require_http_methods(['POST', 'GET'])
@login_required
@permission_required('gap.gap_admin')
def edit_gap(request, gap_id=None):
    template_url = 'gap_admin/gaps/edit_gap.html'

    try:
        gap = GapCtl().find_gap_by_id(gap_id, del_id=False)
    except Exception:
        return HttpResponseServerError()

    try:
        created_by_login = Staff.objects.values_list('login', flat=True).get(id=gap['created_by_id'])
    except Exception:
        return HttpResponseServerError()

    try:
        modified_by_login = Staff.objects.values_list('login', flat=True).get(id=gap['modified_by_id'])
    except Exception:
        return HttpResponseServerError()

    if request.method == 'GET':
        gap['mongo_id'] = str(gap['_id'])
        del gap['_id']

        gap['gap_id'] = gap['id']
        del gap['id']

        gap['date_from'] = gap['date_from'].isoformat()
        gap['date_to'] = gap['date_to'].isoformat()
        gap['created_at'] = gap['created_at'].isoformat()
        gap['created_by_login'] = created_by_login
        gap['modified_at'] = gap['modified_at'].isoformat()
        gap['modified_by_login'] = modified_by_login

        if not gap.get('master_issue'):
            gap['master_issue'] = ''

        if not gap.get('slave_issues'):
            gap['slave_issues'] = ''
        else:
            join_collection(gap, 'slave_issues')

        if 'form_key' not in gap:
            gap['form_key'] = ''

        if 'has_sicklist' not in gap:
            gap['has_sicklist'] = ''

        if 'is_covid' not in gap:
            gap['is_covid'] = ''

        if 'is_selfpaid' not in gap:
            gap['is_selfpaid'] = ''

        join_collection(gap, 'to_notify')

        return render(request, template_url, {'gap': gap})
