import json

from django.contrib.auth.decorators import login_required, permission_required
from django.http import HttpResponse
from django.views.decorators.http import require_GET

from staff.gap.controllers.templates import TemplatesCtl

import logging
logger = logging.getLogger('staff.gap.gap_admin.views.export_templates_view')


@require_GET
@login_required
@permission_required('gap.gap_admin')
def export_templates(request):
    templates = [json.dumps(t) for t in TemplatesCtl().find()]

    response = HttpResponse(
        '\n'.join(templates),
        content_type='application/octet-stream',
    )
    response['Content-Disposition'] = 'attachment; filename=gap_templates.json'

    return response
