import pymongo

from django.contrib.auth.decorators import login_required, permission_required
from django.shortcuts import render
from django.views.decorators.http import require_http_methods

from staff.gap.controllers.templates import TemplatesCtl
from staff.gap.gap_admin.utils import prepare_template_to_view

EDIT_PATTERNS = {
    'email': '/_gap_admin/edit_email_template',
    'pdf': '/_gap_admin/edit_pdf_template',
    'st_issue': '/_gap_admin/edit_st_issue_template',
    'st_issue_comment': '/_gap_admin/edit_st_issue_comment_template',
}


@require_http_methods(['GET'])
@login_required
@permission_required('gap.gap_admin')
def list_templates(request):
    return render(request, 'gap_admin/gap_templates/list.html', {'templates': _get_templates()})


def _get_templates():
    sorting = [
        ('type', pymongo.ASCENDING),
        ('title', pymongo.ASCENDING),
    ]

    templates = [t for t in TemplatesCtl().find(sorting=sorting, del_id=False) if 'transport' not in t]

    for t in templates:
        prepare_template_to_view(t)
        t['edit_url'] = '%s/%s' % (EDIT_PATTERNS[t['type']], t['_id'])

    return templates
