from bson.objectid import ObjectId

from django.core.urlresolvers import reverse
from django.contrib.auth.decorators import login_required, permission_required
from django.views.decorators.http import require_http_methods
from django.http import (
    HttpResponseNotFound,
    HttpResponseRedirect,
)

from staff.gap.controllers.templates import TemplatesCtl

import logging
logger = logging.getLogger('staff.gap.gap_admin.views.remove_template_view')


@require_http_methods(['POST'])
@login_required
@permission_required('gap.gap_admin')
def remove_template(request, template_id):
    t_ctl = TemplatesCtl()
    template = t_ctl.find_one({'_id': ObjectId(template_id)})
    if not template:
        return HttpResponseNotFound()
    t_ctl.remove(template['_id'])
    return HttpResponseRedirect(reverse('gap-admin:list-templates'))
