from django.contrib.auth.decorators import login_required, permission_required
from django.views.decorators.http import require_GET

from staff.lib.decorators import responding_json

from staff.gap.tasks import find_vacations_to_cancel

import logging
logger = logging.getLogger('staff.gap.gap_admin.views.vacations_to_cancel_view')


@require_GET
@login_required
@permission_required('gap.gap_admin')
@responding_json
def vacations_to_cancel(request):
    return find_vacations_to_cancel()
