# -*- coding: utf-8 -*-
from __future__ import unicode_literals

from django.db import migrations, models
import datetime


class Migration(migrations.Migration):

    dependencies = [
        ('django_intranet_stuff', '0001_initial'),
    ]

    operations = [
        migrations.CreateModel(
            name='Permissions',
            fields=[
                ('id', models.AutoField(verbose_name='ID', primary_key=True, serialize=False, auto_created=True)),
            ],
            options={
                'permissions': (('robot_with_gap_api_access', 'Permission for robots group, allows access to gap api'), ('gap_admin', 'Permission for those who has access to gap admin pages')),
                'managed': False,
            },
        ),
        migrations.CreateModel(
            name='Gap',
            fields=[
                ('id', models.AutoField(verbose_name='ID', primary_key=True, serialize=False, auto_created=True)),
                ('state', models.CharField(max_length=32, db_index=True)),
                ('left_edge', models.DateTimeField(db_index=True)),
                ('right_edge', models.DateTimeField(db_index=True)),
                ('description', models.TextField(blank=True)),
                ('created_at', models.DateTimeField(blank=True, default=datetime.datetime.now)),
                ('modified_at', models.DateTimeField(db_index=True, auto_now=True)),
                ('is_hidden', models.BooleanField(db_index=True, default=False)),
                ('created_by', models.ForeignKey(related_name='submited_gaps', to='django_intranet_stuff.Staff')),
            ],
        ),
        migrations.CreateModel(
            name='GapTasksQueue',
            fields=[
                ('id', models.AutoField(verbose_name='ID', primary_key=True, serialize=False, auto_created=True)),
                ('gap_id', models.IntegerField()),
                ('args', models.TextField()),
                ('callable', models.CharField(max_length=128)),
                ('module', models.CharField(max_length=512)),
                ('fail_count', models.IntegerField(default=0)),
            ],
        ),
        migrations.CreateModel(
            name='Workflow',
            fields=[
                ('id', models.AutoField(verbose_name='ID', primary_key=True, serialize=False, auto_created=True)),
                ('name', models.CharField(max_length=15)),
                ('verbose_name', models.CharField(max_length=255)),
                ('color', models.CharField(max_length=7)),
                ('rank', models.IntegerField()),
            ],
        ),
        migrations.AddField(
            model_name='gap',
            name='gap_type',
            field=models.ForeignKey(to='gap.Workflow'),
        ),
        migrations.AddField(
            model_name='gap',
            name='staff',
            field=models.ForeignKey(related_name='gaps', to='django_intranet_stuff.Staff'),
        ),
    ]
