from datetime import datetime
from django.db import models
from staff.person.models import Staff


class Workflow(models.Model):
    name = models.CharField(max_length=15)
    verbose_name = models.CharField(max_length=255)
    color = models.CharField(max_length=7)
    rank = models.IntegerField()

    def __str__(self):
        return self.verbose_name


class Gap(models.Model):

    state = models.CharField(max_length=32, db_index=True)
    gap_type = models.ForeignKey(Workflow)
    left_edge = models.DateTimeField(db_index=True)
    right_edge = models.DateTimeField(db_index=True)
    description = models.TextField(blank=True)
    created_at = models.DateTimeField(default=datetime.now, blank=True)
    modified_at = models.DateTimeField(auto_now=True, db_index=True)

    created_by = models.ForeignKey(Staff, related_name='submited_gaps')
    staff = models.ForeignKey(Staff, related_name='gaps')

    is_hidden = models.BooleanField(default=False, db_index=True)


class Permissions(models.Model):
    class Meta:
        managed = False  # No database table creation or deletion operations will be performed for this model
        permissions = (
            ('robot_with_gap_api_access', 'Permission for robots group, allows access to gap api'),
            ('gap_admin', 'Permission for those who has access to gap admin pages'),
            ('can_delete_mandatory_vacation', 'Can delete mandatory vacation'),
            ('can_edit_mandatory_vacation', 'Can edit mandatory vacation'),
        )


class GapTasksQueue(models.Model):
    gap_id = models.IntegerField(null=False)
    args = models.TextField()
    callable = models.CharField(max_length=128)
    module = models.CharField(max_length=512)
    fail_count = models.IntegerField(default=0, null=False)
