from django.template import Template
from staff.django_intranet_notifications import Notification


HTML_TEMPLATE = '<!DOCTYPE HTML><html><head><meta charset="UTF-8"></head><body>%s</body></html>'


class BaseGapEmailNotification(Notification):

    def __init__(self, template, context):
        super().__init__(
            target='GAP',
            context=context,
        )
        template_parts = template.split('\n\n', 1)
        self._template = '%s\n\n%s' % (template_parts[0], HTML_TEMPLATE % template_parts[1])

    def send(self, **params):
        route = self.get_route()
        transport = self.get_transport(route)
        transport.prepare_message(context=self.context, template=self.template)
        return transport.deliver_message(**params)

    @property
    def template(self):
        return Template(self._template)

    def get_template_path(self):
        return Template(self._template)


class GapEmailNotification(BaseGapEmailNotification):

    def __init__(self, gap_id, template, context):
        self.gap_id = gap_id
        super().__init__(template, context)

    def get_subj_id(self):
        return self.gap_id


class PeriodicGapEmailNotification(BaseGapEmailNotification):

    def __init__(self, periodic_gap_id, template, context):
        self.periodic_gap_id = periodic_gap_id
        super().__init__(template, context)

    def get_subj_id(self):
        return self.periodic_gap_id
