from django import forms

from staff.gap.base_forms import CommaSeparatedStrings


class StaffCurrentForm(forms.Form):

    ENCODING_CHOICES = [
        ('windows-1251', 'windows-1251'),
        ('utf-8', 'utf-8'),
        ('utf8', 'utf8')]

    ext = forms.CharField(required=False)
    login_list = CommaSeparatedStrings(required=False)
    future_lookup = forms.IntegerField(min_value=0, required=False)
    encoding = forms.ChoiceField(
        required=False,
        choices=ENCODING_CHOICES,
    )


class StaffPresenceForm(forms.Form):
    login_list = CommaSeparatedStrings(required=True)
    dt = forms.DateTimeField(required=False)


class GapListForm(forms.Form):

    period_from = forms.DateField()
    period_to = forms.DateField()
    gap_type = forms.CharField(required=False)
    login_list = CommaSeparatedStrings(required=False)
