from django.conf.urls import include, url

from staff.gap.edit_views.edit_gap_view import edit_gap
from staff.gap.edit_views.gap_state_views import cancel_gap, sign_gap, confirm_gap

from staff.gap.views.analytics import gaps_with_countries
from staff.gap.views.gaps_by_day_views import gaps_by_day, gaps_by_id
from staff.gap.views.gaps_by_person_meta_view import gaps_by_person_meta
from staff.gap.views.gaps_calendar_view import gaps_calendar
from staff.gap.views.gaps_history_view import gaps_history
from staff.gap.views.unconfirmed_gaps_view import unconfirmed_gaps
from staff.gap.views.vacation_views import distribute_vacations, vacation_file

urlpatterns = [
    url(
        r'^gaps/?$',
        gaps_by_person_meta,
        name='gaps-by-person-meta',
    ),
    url(
        r'^gaps/(?P<login>[\w\-\_\.]+)/?$',
        gaps_by_person_meta,
        name='gaps-by-person-meta',
    ),
    url(
        r'^gaps_by_id/(?P<gap_id>\d+)/?$',
        gaps_by_id,
        name='gaps-by-id',
    ),
    url(
        r'^gaps_calendar/?$',
        gaps_calendar,
        name='gaps-calendar',
    ),
    url(
        r'^gaps_by_day/?$',
        gaps_by_day,
        name='gaps-by-day',
    ),
    url(
        r'^gaps_history/?$',
        gaps_history,
        name='gaps-history',
    ),
    url(
        r'^unconfirmed_gaps/?$',
        unconfirmed_gaps,
        name='unconfirmed-gaps',
    ),
    url(
        r'^distribute_vacations/(?P<login>[\w\-\_\.]+)/?$',
        distribute_vacations,
        name='distribute-vacations',
    ),
    url(
        r'^vacation_file/(?P<gap_id>\d+)/?$',
        vacation_file,
        name='vacation-file',
    ),
    url(
        r'^gaps-with-countries/?$',
        gaps_with_countries,
        name='confirm-gap',
    ),

    url(
        r'^gap/edit/(?P<login>[\w\-\_\.]+)/?$',
        edit_gap,
        name='edit-gap',
    ),
    url(
        r'^gap/edit/(?P<login>[\w\-\_\.]+)/(?P<gap_id>\d+)/?$',
        edit_gap,
        name='edit-gap',
    ),
    url(
        r'^gap/(?P<gap_id>\d+)/cancel/?$',
        cancel_gap,
        name='cancel-gap',
    ),
    url(
        r'^gap/(?P<gap_id>\d+)/sign/?$',
        sign_gap,
        name='sign-gap',
    ),
    url(
        r'^gap/(?P<gap_id>\d+)/confirm/?$',
        confirm_gap,
        name='confirm-gap',
    ),

    url(r'^old_api/', include('staff.gap.old_api.urls')),
    url(r'^api/', include('staff.gap.api.urls')),
]
