from datetime import date

from django.contrib.auth.models import User

from staff.gap.workflows import TRIP_WORKFLOWS


def show_edit_button(observer: User, gap: dict) -> bool:
    is_gap_possible_to_edit = (
        gap['workflow'] != 'duty'
        and not (
            gap.get('mandatory', False)
            and 'deadline' in gap
            and gap['deadline'].date() < date.today()
        )
    )

    if is_gap_possible_to_edit:
        return True

    return (
        gap['workflow'] == 'vacation' and
        observer.has_perm('gap.can_edit_mandatory_vacation')
    )


def show_delete_button(observer: User, gap: dict):
    is_gap_possible_to_cancel = (
            gap['workflow'] not in TRIP_WORKFLOWS + ['duty']
            and not gap.get('mandatory', False)
    )

    if is_gap_possible_to_cancel:
        return True

    return (
        gap['workflow'] == 'vacation' and
        observer.has_perm('gap.can_delete_mandatory_vacation')
    )
