import math

from django.views.decorators.http import require_GET
from django.http import HttpResponseNotFound, HttpResponseForbidden

from staff.gap.permissions import get_accessible_logins
from staff.lib.decorators import responding_json, available_for_external
from staff.gap.controllers.meta import find_person, get_calendar_legend
from staff.gap.controllers.unconfirmed import unconfirmed_for_ui

import logging
logger = logging.getLogger('staff.gap.views.gaps_by_person_meta_view')


@responding_json
@require_GET
@available_for_external
def gaps_by_person_meta(request, login=None):
    answer = {}
    observer = request.user
    observer_person = observer.get_profile()
    observer_id = observer_person.id
    observer_login = observer_person.login
    observer_tz = observer_person.tz

    if not get_accessible_logins(observer.get_profile(), [login or observer_login]):
        logger.info('%s has no access to %s gap', observer, login or observer_login)
        return HttpResponseForbidden()

    person = find_person(login or observer_login, observer_login)

    if not person:
        return HttpResponseNotFound()

    if person['login'] != login or login is None:
        answer['redirect_login'] = person['login']

    can_distribute = _can_distribute(person)

    if person['vacation'] is not None:
        person['vacation'] = math.floor(person['vacation'])
    else:
        del person['vacation']

    answer['can_distribute'] = can_distribute
    answer['person'] = person
    answer['calendar_legend'] = get_calendar_legend()
    answer['subscriptions'] = []
    answer['unconfirmed'] = unconfirmed_for_ui(observer_id, target_id=person['id'])
    answer['observer_tz'] = observer_tz
    answer['service_is_readonly'] = bool(request.service_is_readonly)

    return answer


def _can_distribute(person):
    return person['country_id'] == 1 and person['vacation'] and person['vacation'] >= 1
