from staff.lib.utils.ordered_choices import OrderedChoices

GAP_STATES = OrderedChoices(
    ('NEW', 'new'),
    ('SIGNED', 'signed'),
    ('CONFIRMED', 'confirmed'),
    ('CANCELED', 'canceled'),
)

LIMITED_STATES = [
    ([
         'absence', 'illness', 'learning', 'maternity', 'vacation', 'paid_day_off', 'conference',
         'remote_work', 'office_work',
     ],
     [GAP_STATES.NEW, GAP_STATES.SIGNED, GAP_STATES.CONFIRMED]),
    (['trip', 'conference_trip'],
     [GAP_STATES.CONFIRMED]),
    (['duty'], [GAP_STATES.NEW, GAP_STATES.CANCELED]),
]

LIMITED_STATES_HISTORY = [
    ([
         'absence', 'illness', 'learning', 'maternity', 'vacation', 'paid_day_off', 'conference',
         'remote_work', 'office_work',
     ],
     [GAP_STATES.NEW, GAP_STATES.SIGNED, GAP_STATES.CONFIRMED, GAP_STATES.CANCELED]),
    (['trip', 'conference_trip'],
     [GAP_STATES.CONFIRMED]),
    (['duty'], [GAP_STATES.NEW, GAP_STATES.CANCELED]),
]

OFFICE_PLACE_STATES = OrderedChoices(
    ('NOPLACE', 'noplace'),
    ('TEAMROOM', 'teamroom'),
    ('COWORKING', 'coworking'),
)

FRONTEND_WORKFLOWS = OrderedChoices(
    ('ABSENCE', 'absence', 'gap.workflow.absence'),
    ('REMOTE_WORK', 'remote_work', 'gap.workflow.remote_work'),
    ('OFFICE_WORK', 'office_work', 'gap.workflow.office_work'),
    ('TRIP', 'trip', 'gap.workflow.trip'),
    ('CONFERENCE_TRIP', 'conference_trip', 'gap.workflow.conference_trip'),
    ('CONFERENCE', 'conference', 'gap.workflow.conference'),
    ('LEARNING', 'learning', 'gap.workflow.learning'),
    ('VACATION', 'vacation', 'gap.workflow.vacation'),
    ('PAID_DAY_OFF', 'paid_day_off', 'gap.workflow.paid_day_off'),
    ('ILLNESS', 'illness', 'gap.workflow.illness'),
    ('MATERNITY', 'maternity', 'gap.workflow.maternity'),
)
