from staff.gap.workflows.base_workflow import BaseTripWorkflow


class ConferenceWorkflow(BaseTripWorkflow):

    editable_fields = []

    workflow = 'conference'
    ui_key = 'gap.workflow.conference'
    gap_type = 'conference'
    verbose_name = 'Конференция'
    verbose_name_en = 'Conference'
    color = '#abd46e'

    template_context = {
        'new_gap_head_ru': 'Конференция создана',
        'new_gap_head_en': 'Conference was created',
        'edit_gap_head_ru': 'Конференция изменена',
        'edit_gap_head_en': 'Conference was edited',
        'cancel_gap_head_ru': 'Конференция отменена',
        'cancel_gap_head_en': 'Conference was canceled',
    }

    def tq_add_gap(self, data):
        if 'full_day' not in data:
            data['full_day'] = True
        if 'work_in_absence' not in data:
            data['work_in_absence'] = False
        self._create_self_gap(data)

        return self.gap['id']
