from staff.gap.workflows.base_workflow import BaseTripWorkflow
from staff.gap.controllers.gap import GapCtl


class ConferenceTripWorkflow(BaseTripWorkflow):

    editable_fields = []

    workflow = 'conference_trip'
    ui_key = 'gap.workflow.conference_trip'
    gap_type = 'conference_trip'
    verbose_name = 'Командировка на конференцию'
    verbose_name_en = 'Conference trip'
    color = '#abd46e'

    template_context = {
        'new_gap_head_ru': 'Командировка на конференцию создана',
        'new_gap_head_en': 'Conference trip was created',
        'edit_gap_head_ru': 'Командировка на конференцию изменена',
        'edit_gap_head_en': 'Conference trip was edited',
        'cancel_gap_head_ru': 'Командировка на конференцию отменена',
        'cancel_gap_head_en': 'Conference trip was canceled',
    }

    def tq_add_gap(self, data):
        old_gap_id = self._check_new_form_key(data['form_key'], self.person['id'])
        if old_gap_id:
            self.gap = GapCtl().find_gap_by_id(old_gap_id)
            return old_gap_id

        if 'full_day' not in data:
            data['full_day'] = True
        if 'work_in_absence' not in data:
            data['work_in_absence'] = False
        self._create_self_gap(data)

        return self.gap['id']
