from functools import wraps

from django.http import HttpResponseBadRequest


def allowed_states(states):
    def decorator(f):
        def wrapper(self, *args, **kwargs):
            if 'gap' in kwargs:
                state = kwargs['gap']['state']
            elif self.gap:
                state = self.gap['state']
            else:
                state = self.periodic_gap['state']
            if states and state not in states:
                return HttpResponseBadRequest('Transition is not allowed for this state')
            return f(self, *args, **kwargs)
        return wrapper
    return decorator


def valid_gap_id(view):
    @wraps(view)
    def wrapper(request, gap_id, *args, **kwargs):
        try:
            int(gap_id)
        except (ValueError, TypeError):
            return HttpResponseBadRequest('Inavlid gap')
        return view(request, gap_id, *args, **kwargs)
    return wrapper
