from staff.gap.workflows.base_workflow import BaseWorkflow
from staff.gap.workflows.decorators import allowed_states
from staff.gap.workflows.choices import GAP_STATES as GS


class DutyWorkflow(BaseWorkflow):

    editable_fields = [
        'service_slug',
        'service_name',
        'shift_id',
        'role_on_duty',
        'full_day',
        'person_login',
        'person_id',
    ] + BaseWorkflow.editable_fields

    workflow = 'duty'
    ui_key = 'gap.workflow.duty'
    gap_type = 'duty'
    verbose_name = 'Дежурство'
    verbose_name_en = 'Duty'
    color = '#4260c2'

    template_context = {
        'new_gap_head_ru': 'Дежурство создано',
        'new_gap_head_en': 'Duty was created',
        'edit_gap_head_ru': 'Дежурство изменено',
        'edit_gap_head_en': 'Duty was edited',
        'cancel_gap_head_ru': 'Дежурство отменено',
        'cancel_gap_head_en': 'Duty was canceled',
    }

    def new_gap(self, data):
        self._create_self_gap(data)
        return self.gap

    def _append_gap(self, data):
        return {
            'service_slug': data.get('service_slug'),
            'service_name': data.get('service_name'),
            'shift_id': data.get('shift_id'),
            'role_on_duty': data.get('role_on_duty'),
        }

    @allowed_states([GS.NEW])
    def edit_gap(self, data: dict) -> None:
        updated = self._update_editable(data, self.editable_fields)

        if not updated:
            return

        self._update()

    @allowed_states([GS.NEW])
    def cancel_gap(self) -> None:
        self._remove()
