import sform

from staff.gap.workflows.utils import find_form
from staff.lib.utils.ordered_choices import OrderedChoices


def workflow_form_factory(names):
    forms = [find_form(n) for n in names]
    choices = OrderedChoices(
        *[(n.upper(), n, f'gap.workflow.{n}') for n in names]
    )

    class WorkflowForm(*forms):
        workflow = sform.ChoiceField(
            choices=choices,
            state=sform.READONLY,
            empty_label='-',
        )

    return WorkflowForm
