from staff.gap.controllers.utils import get_chief
from staff.gap.workflows.base_workflow import BaseWorkflow
from staff.gap.workflows.decorators import allowed_states
from staff.gap.workflows.choices import GAP_STATES as GS


class LearningWorkflow(BaseWorkflow):
    editable_fields = [
        'full_day',
    ] + BaseWorkflow.editable_fields

    workflow = 'learning'
    ui_key = 'gap.workflow.learning'
    gap_type = 'learning'
    verbose_name = 'Обучение'
    verbose_name_en = 'Learning'
    color = '#00c09c'

    template_context = {
        'new_gap_head_ru': 'Обучение создано',
        'new_gap_head_en': 'Learning was created',
        'edit_gap_head_ru': 'Обучение изменено',
        'edit_gap_head_en': 'Learning was edited',
        'cancel_gap_head_ru': 'Обучение отменено',
        'cancel_gap_head_en': 'Learning was canceled',
    }

    def new_gap(self, data):
        self._create_self_gap(data)

        self._new_gap_email(approver=get_chief(self.gap['person_login']))

        return self.gap

    @allowed_states([GS.NEW])
    def edit_gap(self, data):
        updated = self._update_editable(data, self.editable_fields)
        if not updated:
            return

        self._update()

        self._new_to_notify(updated)
        self._edit_gap_email(updated, approver=get_chief(self.gap['person_login']))

    @allowed_states([GS.NEW])
    def cancel_gap(self):
        self._set_state(GS.CANCELED)

        self._update()

        self._cancel_gap_email(approver=get_chief(self.gap['person_login']))
