from staff.gap.controllers.utils import get_chief
from staff.gap.workflows.base_workflow import BaseWorkflow
from staff.gap.workflows.decorators import allowed_states
from staff.gap.workflows.choices import GAP_STATES as GS


class MaternityWorkflow(BaseWorkflow):

    workflow = 'maternity'
    ui_key = 'gap.workflow.maternity'
    gap_type = 'maternity'
    verbose_name = 'Отпуск по уходу'
    verbose_name_en = 'Maternity'
    color = '#dc97ca'

    template_context = {
        'new_gap_head_ru': 'Отпуск по уходу создан',
        'new_gap_head_en': 'Maternity was created',
        'edit_gap_head_ru': 'Отпуск по уходу изменён',
        'edit_gap_head_en': 'Maternity was edited',
        'cancel_gap_head_ru': 'Отпуск по уходу отменён',
        'cancel_gap_head_en': 'Maternity was canceled',
    }

    def new_gap(self, data):
        self._create_self_gap(data)

        self._new_gap_email(approver=get_chief(self.gap['person_login']))

        return self.new_issue('new_maternity')

    def _append_gap(self, data):
        return {
            'master_issue': data.get('master_issue'),
        }

    def _append_base_default(self):
        return {
            'master_issue': None,
        }

    @allowed_states([GS.NEW])
    def edit_gap(self, data):
        updated = self._update_editable(data, self.editable_fields)
        if not updated:
            return

        self._update()
        self._new_to_notify(updated)

        if not updated:
            return

        self.issue_comment('edit_gap', gap_diff=updated, reset_dates=True)
        self._edit_gap_email(updated, approver=get_chief(self.gap['person_login']))

    @allowed_states([GS.NEW])
    def cancel_gap(self):
        self._set_state(GS.CANCELED)

        self._update()
        self._cancel_gap_email(approver=get_chief(self.gap['person_login']))
        self.issue_comment('cancel_maternity')
