from staff.lib.utils.qs_values import localize
from staff.map.models import Office, Room, Table


def get_office(pk: int) -> dict:
    return Office.objects.filter(pk=pk).values('name', 'name_en').first()


def get_room(pk: int) -> dict:
    return Room.objects.filter(pk=pk).values('name', 'name_en', 'num').first()


def get_table(pk: int) -> dict:
    return Table.objects.filter(pk=pk).values('num').first()


FIELD_MAPPING = {
    'office': get_office,
    'room': get_room,
    'table': get_table,
    'coworking': get_room,
}


def get_office_work_extra(gap):
    data = {}
    for field_name in FIELD_MAPPING.keys():
        obj_id = gap.get(field_name)
        if not obj_id:
            continue

        field_data = FIELD_MAPPING[field_name](obj_id)
        if not field_data:
            continue

        data.update(**{f'{field_name}_{key}': value for key, value in field_data.items()})

    data = localize(data)
    gap.update(data)
    return gap
