from staff.gap.workflows.base_workflow import BaseWorkflow
from staff.gap.workflows.decorators import allowed_states
from staff.gap.workflows.choices import GAP_STATES as GS

from staff.gap.controllers.utils import get_chief


class PaidDayOffWorkflow(BaseWorkflow):

    workflow = 'paid_day_off'
    ui_key = 'gap.workflow.paid_day_off'
    gap_type = 'paid_day_off'
    verbose_name = 'Отгул'
    verbose_name_en = 'Paid day off'
    color = '#73c9eb'

    template_context = {
        'new_gap_head_ru': 'Отгул создан',
        'new_gap_head_en': 'Paid day off was created',
        'edit_gap_head_ru': 'Отгул изменён',
        'edit_gap_head_en': 'Paid day off was edited',
        'cancel_gap_head_ru': 'Отгул отменён',
        'cancel_gap_head_en': 'Paid day off was canceled',
    }

    def new_gap(self, data):
        self._create_self_gap(data)

        self._new_gap_email(approver=get_chief(self.gap['person_login']))

        followers = []
        chief = get_chief(self.person['login'])
        if chief and chief['login'] not in ['volozh', 'shulgin']:  # STAFF-7740
            followers.append(chief['login'])

        return self.new_issue('new_paid_day_off', append_followers=followers)

    @allowed_states([GS.NEW])
    def edit_gap(self, data):
        updated = self._update_editable(data, self.editable_fields)
        if not updated:
            return

        self._update()
        self._new_to_notify(updated)

        if not updated:
            return

        self.issue_comment('edit_gap', gap_diff=updated, reset_dates=True)
        self._edit_gap_email(updated, approver=get_chief(self.gap['person_login']))

    @allowed_states([GS.NEW])
    def cancel_gap(self, send_email=True, issue_comment_tag='cancel_paid_day_off'):
        self._set_state(GS.CANCELED)

        self._update()

        if send_email:
            self._cancel_gap_email(approver=get_chief(self.gap['person_login']))

        self.issue_comment(issue_comment_tag)
