from importlib import import_module

from staff.lib.utils.library import Library


WORKFLOWS = [
    ('absence', 'Absence'),
    ('remote_work', 'RemoteWork'),
    ('office_work', 'OfficeWork'),
    ('illness', 'Illness'),
    ('learning', 'Learning'),
    ('maternity', 'Maternity'),
    ('trip', 'Trip'),
    ('vacation', 'Vacation'),
    ('paid_day_off', 'PaidDayOff'),
    ('conference_trip', 'ConferenceTrip'),
    ('conference', 'Conference'),
    ('duty', 'Duty'),
]


def _register_class(workflow, title, module_pattern, class_pattern):
    module = import_module(module_pattern % workflow)
    class_name = class_pattern % title
    if hasattr(module, class_name):
        library.register(getattr(module, class_name))


library = Library(lambda x: x.__name__)


for workflow, title in WORKFLOWS:
    _register_class(workflow, title, 'staff.gap.workflows.%s.forms', '%sForm')
    _register_class(workflow, title, 'staff.gap.workflows.%s.workflow', '%sWorkflow')
