from staff.gap.workflows.base_workflow import BaseTripWorkflow
from staff.gap.controllers.gap import GapCtl


class TripWorkflow(BaseTripWorkflow):

    editable_fields = []

    workflow = 'trip'
    ui_key = 'gap.workflow.trip'
    gap_type = 'trip'
    verbose_name = 'Командировка'
    verbose_name_en = 'Trip'
    color = '#abd46e'

    template_context = {
        'new_gap_head_ru': 'Командировка создана',
        'new_gap_head_en': 'Trip was created',
        'edit_gap_head_ru': 'Командировка изменена',
        'edit_gap_head_en': 'Trip was edited',
        'cancel_gap_head_ru': 'Командировка отменена',
        'cancel_gap_head_en': 'Trip was canceled',
    }

    def tq_add_gap(self, data):
        old_gap_id = self._check_new_form_key(data['form_key'], self.person['id'])
        if old_gap_id:
            self.gap = GapCtl().find_gap_by_id(old_gap_id)
            return old_gap_id

        if 'full_day' not in data:
            data['full_day'] = True
        if 'work_in_absence' not in data:
            data['work_in_absence'] = True
        self._create_self_gap(data)

        return self.gap['id']

    def cancel_gap(self):
        self.tq_cancel_gap()
