import sform

from staff.gap.workflows.base_forms import BaseGapForm, ToNotifyForm


class CountriesArrayField(sform.Field):
    @property
    def type_name(self):
        return 'multiplesuggest'

    def structure_as_dict(self, *args, **kwargs):
        field_dict = super().structure_as_dict(*args, **kwargs)
        field_dict['types'] = ['countries']
        return field_dict

    def clean(self, new_value, old_value, required, trim_on_empty, base_initial, base_data):
        return new_value


class VacationForm(BaseGapForm):
    comment = sform.CharField(state=sform.NORMAL, default='', max_length=512)
    to_notify = sform.GridField(sform.FieldsetField(ToNotifyForm))
    is_selfpaid = sform.BooleanField(default=False)
    countries_to_visit = CountriesArrayField(state=sform.NORMAL, default=[])
    mandatory = sform.BooleanField(default=False, state=sform.READONLY)
    vacation_updated = sform.BooleanField(default=False, state=sform.READONLY)
