from django import forms
from django.core.exceptions import ValidationError

from staff.person.models import Staff

from staff.achievery.models import Achievement


class GiveAchievementsForm(forms.Form):
    params = forms.CharField(
        widget=forms.Textarea(attrs={'class': 'form-control'})
    )
    achievement = forms.ModelChoiceField(
        Achievement.active.all(),
        widget=forms.Select(attrs={'class': 'form-control'}),
    )
    author = forms.CharField(
        widget=forms.TextInput(attrs={'class': 'form-control'}),
    )

    def clean_author(self):
        author = self.cleaned_data['author'].strip()
        try:
            return Staff.objects.get(login=author)
        except Staff.DoesNotExist:
            raise ValidationError('No such person')

    def clean_params(self):
        params = self.cleaned_data['params'].splitlines()
        result_params = []
        for line in params:
            try:
                login, level, comment = line.split(';', 2)
            except ValueError:
                raise ValidationError('";" is missing somewhere in your csv')
            try:
                level = int(level)
            except ValueError:
                raise ValidationError('Wrong level number')
            result_params.append(
                {
                    'login': login,
                    'level': level,
                    'comment': comment,
                }
            )
        return result_params
