from django.shortcuts import render
from django.http import Http404

from staff.achievery.serializers import ExceptionBlockSerializer
from staff.lib.decorators import require_permission

from .controller import AchievementMassGiver
from .forms import GiveAchievementsForm


@require_permission('django_intranet_stuff.can_mass_give_achievements',
                    exception=Http404)
def give_achievements(request):
    form = GiveAchievementsForm(request.POST.copy() or None)

    alert = '', None

    if request.method == 'POST' and form.is_valid():
        giver = AchievementMassGiver(**form.cleaned_data)
        results = giver.give()

        alert = 'Done!', 'success'

        failed = [r.object for r in results if not r]
        if failed:
            alert = 'BOOM!', 'danger'
            errors = [r.error for r in results if not r]

            form.data['params'] = '\n'.join([
                ';'.join([f['login'], str(f['level']), f['comment']])
                for f in failed
            ])
            form._errors['params'] = form.error_class(
                ExceptionBlockSerializer(errors, many=True).data)
        else:
            form.data['params'] = []

    return render(
        request,
        'give_achievements.html',
        {
            'form': form,
            'alert_message': alert[0],
            'alert_class': alert[1],
        }
    )
