from django.contrib import admin

from staff.lib.utils.admin import StaffModelAdmin, BaseIntranetAdmin, AutocompleteMixin

from staff.groups.forms import AutogroupForm
from staff.groups.models import AutoGroupTemplate, Group, GroupMembership, GroupResponsible, ServiceUpdateTasksQueue


class AutoGroupTemplateAdmin(admin.ModelAdmin):
    form = AutogroupForm
    list_display = ('id', 'group', 'name', 'code')
    list_display_links = ('id', 'name')
    list_editable = ('code', )


class GroupMembershipAdmin(StaffModelAdmin):
    list_display = ('staff', 'group', 'joined_at')


class GroupResponsibleAdmin(StaffModelAdmin):
    list_display = ('staff', 'group', 'permitted_at')


class GroupAdmin(BaseIntranetAdmin, AutocompleteMixin):
    list_display = 'url', 'name', 'type', 'service_id', 'department'
    search_fields = 'url', 'name', 'service_tags'
    ordering = 'url',
    list_filter = 'type', 'intranet_status'
    readonly_fields = 'externals_count', 'yandex_count', 'yamoney_count', 'role_scope_id'
    not_required_fields = 'description',
    filter_horizontal = 'permissions',

    department_field = 'department'
    group_field = 'parent'

    def formfield_for_foreignkey(self, db_field, request=None, **kwargs):
        autocomplete_field = self.maybe_autocomplete_formfield(db_field)
        if autocomplete_field is not None:
            return autocomplete_field

        return super(GroupAdmin, self).formfield_for_foreignkey(
            db_field, request, **kwargs)


class ServiceUpdateTasksQueueAdmin(StaffModelAdmin):
    list_display = ('id', 'service_id', 'module', 'callable', 'fail_count', 'args')
    ordering = ('service_id', 'id')


admin.site.register(Group, GroupAdmin)
admin.site.register(AutoGroupTemplate, AutoGroupTemplateAdmin)
admin.site.register(GroupMembership, GroupMembershipAdmin)
admin.site.register(GroupResponsible, GroupResponsibleAdmin)
admin.site.register(ServiceUpdateTasksQueue, ServiceUpdateTasksQueueAdmin)
