import yenv

from django import forms

from .models import AutoGroupTemplate
from .autogroup import load_query
from .tasks import UpdateAutogroups


class AutogroupForm(forms.ModelForm):
    class Meta:
        fields = '__all__'
        model = AutoGroupTemplate

    def query_clean(self, field):
        condition = self.cleaned_data[field].strip()
        try:
            load_query(condition)
        except Exception as e:
            raise forms.ValidationError(e)
        return condition

    def clean_condition(self):
        return self.query_clean('condition')

    def clean_exclusion(self):
        return self.query_clean('exclusion')

    def save(self, *args, **kwargs):
        instance = super(AutogroupForm, self).save(*args, **kwargs)

        if yenv.type == 'development':
            method = UpdateAutogroups
        else:
            method = UpdateAutogroups.delay

        method(template_ids=[instance.id])
        return instance
