from django.dispatch import receiver
from staff.audit.factory import create_log

from ..signals import group_created, group_updated, group_deleted
from ..signals import group_member_added, group_member_deleted


@receiver(group_created)
def handle_group_created(sender, request, group, **kw):
    create_log(
        objects=[group],
        who=request and request.user,
        action='group_created',
        primary_key=group.pk
    )


@receiver(group_updated)
def handle_group_updated(sender, request, group, **kw):
    create_log(
        objects=[group],
        who=request and request.user,
        action='group_updated',
        primary_key=group.pk
    )


@receiver(group_deleted)
def handle_group_deleted(sender, request, group, **kw):
    create_log(
        objects=[group],
        who=request and request.user,
        action='group_deleted',
        primary_key=group.pk
    )


@receiver(group_member_added)
def handle_group_member_added(sender, request, group, staff, **kw):
    create_log(
        objects=[group, staff],
        who=request and request.user,
        action='group_member_added',
        primary_key=group.pk
    )


@receiver(group_member_deleted)
def handle_group_member_deleted(sender, request, group, staff, **kw):
    create_log(
        objects=[group, staff],
        who=request and request.user,
        action='group_member_deleted',
        primary_key=group.pk
    )
