import logging

from django.core.management.base import BaseCommand

from staff.groups.tasks import UpdateAutogroups


logger = logging.getLogger(name=__name__)


class Command(BaseCommand):
    help = "Update automatically-generated groups"

    def handle(self, *args, **options):
        verbosity = int(options.get('verbosity', 1))
        try:
            UpdateAutogroups(verbosity)
        except Exception:
            logger.exception('UpdateAutogroups')
