from django.conf import settings

from staff.lib.requests import get_ids_repository
from staff.lib.tvm2 import get_tvm_ticket_by_deploy

from staff.groups.service.helpers import normalize_data


def _get_service_data(abc_data):
    name_en = abc_data.get('name', {}).get('en', None)
    service_data = normalize_data(abc_data)
    service_data['name_en'] = name_en
    return service_data


def get_services(lookup, **options):
    services = get_ids_repository(
        'abc',
        'service',
        user_agent=settings.STAFF_USER_AGENT,
        service_ticket=get_tvm_ticket_by_deploy('abc'),
        api_version=4,
        host=settings.ABC_HOST,
        **options,
    )

    # id предполагается передавать в виде одного инта,
    # фильтр по ренжу id'шников ABC не умеет (да и не нужно)
    service_id = lookup.get('id')
    if service_id:
        yield int(service_id), _get_service_data(services.get_one(lookup))
    else:
        for service in services.getiter(lookup=lookup):
            yield int(service['id']), _get_service_data(service)


def get_service_members(lookup, **options):
    service_members_repo = get_ids_repository(
        'abc',
        'service_members',
        user_agent=settings.STAFF_USER_AGENT,
        service_ticket=get_tvm_ticket_by_deploy('abc'),
        api_version=4,
        host=settings.ABC_HOST,
        **options,
    )

    for member in service_members_repo.getiter(lookup=lookup):
        yield member
