from staff.groups.models import Group


def get_service_root():
    root = getattr(get_service_root, '_cached', None)
    if not root:
        root = Group.objects.get(code='__services__')
        setattr(get_service_root, '_cached', root)

    return root


def normalize_data(data):
    if isinstance(data, dict):
        if set(data) == {'ru', 'en'}:
            return data['ru']
        elif set(data) == {'wiki', 'html'}:
            return normalize_data(data['html'])
        else:
            for key, value in data.items():
                data[key] = normalize_data(value)
            return data
    if isinstance(data, list):
        for num, item in enumerate(data):
            data[num] = normalize_data(item)
    return data
