from typing import List

from staff.person.models import Staff

from staff.headcounts.permissions import Permissions
from staff.headcounts.headcounts_credit_management import use_cases


class HeadcountsPermissions(use_cases.PermissionsInterface):
    def __init__(self, author: Staff):
        self._wrapped = Permissions(author)

    def has_special_role(self) -> bool:
        return self._wrapped.has_special_role()

    def has_access_to_application(self, author_login: str) -> bool:
        return self._wrapped.has_access_to_credit_management_application(author_login)

    def can_create_applications(self, budget_position_ids: List[int]) -> bool:
        return self._wrapped.can_create_applications(budget_position_ids)

    def can_confirm_applications(self) -> bool:
        return self._wrapped.can_confirm_applications()

    def can_cancel_applications(self) -> bool:
        return self._wrapped.can_cancel_applications()

    def person(self) -> Staff:
        return self._wrapped.observer
