from staff.budget_position.workflow_service import (
    CreditRepaymentData,
    WorkflowRegistryService,
    ConflictWorkflowExistsError,
)
from staff.departments.controllers.exceptions import BpConflict

from staff.headcounts.headcounts_credit_management import use_cases


class Workflows(use_cases.Workflows):
    def __init__(self, workflow_service: WorkflowRegistryService):
        self._workflow_service = workflow_service

    def create_workflow(self, credit_repayment: use_cases.CreditRepayment):
        conflicts = []

        for row in credit_repayment.rows:
            workflow_data = CreditRepaymentData(
                credit_management_id=credit_repayment.id,
                credit_budget_position=row.credit_budget_position.code,
                repayment_budget_position=row.repayment_budget_position.code,
                vacancy_id=row.repayment_budget_position.vacancy_id,
                ticket=credit_repayment.ticket,
            )

            try:
                row.workflow_id = self._workflow_service.try_create_workflow_for_credit_repayment(workflow_data)
            except ConflictWorkflowExistsError as e:
                for workflow in e.conflicting_workflows:
                    conflict = {'bp_id': workflow.changes[0].budget_position.code}
                    if workflow.proposal_id is not None:
                        conflict.update({
                            'proposal_id': workflow.proposal_meta.proposal_id,
                            'author': workflow.proposal_meta.author.login,
                        })
                    elif workflow.credit_management_id is not None:
                        conflict.update({
                            'credit_management_id': workflow.credit_management_application.id,
                            'author': workflow.credit_management_application.author.login,
                            'ticket': workflow.credit_management_application.startrek_headcount_key,
                        })
                    conflicts.append(conflict)

        if conflicts:
            raise BpConflict(conflicts)

    def cancel_workflow(self, credit_repayment_id: int) -> None:
        self._workflow_service.cancel_workflows_for_credit_repayment(credit_repayment_id)
