from staff.lib.db import atomic

from staff.headcounts.headcounts_credit_management.use_cases.interfaces import RepositoryInterface


class CancelUseCase:
    def __init__(self, repository: RepositoryInterface):
        self._repository = repository

    @atomic
    def cancel(self, credit_repayment_id: int) -> None:
        self._repository.deactivate_application(credit_repayment_id)
